//Experiment Number:3 
//Write a program to perform SSB modulation and demodulation and study its spectral characteristics
//Analog and Digital Communication Laboratory 
//B.Tech II Year II Sem
//Student Name:               Enrolment Number:  
// Course Instructor: Aqeel Shaik
// Sreyas Institute Of Engineering & Technology, Hyderabad.
//-------------------------------------------------------------------------------//


// OS : Windows 10.1
// Scilab 6.0.2

clc;
clear;
close;

fs=200
t=0:1/fs:2;
p=length(t);

fm=input('Enter the message signal frequency =');
fc=input('Enter the carrier signal frequency (fc>>>fm) =');
am=input('Enter the message signal amplitude =');
ac=input('Enter the carrier signal amplitude =');

// Message Signal Generation

msg=am*cos(2*%pi*fm*t); 

figure(1);
subplot(4,1,1);
plot(t,msg);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Message Signal');

//Carrier Signal generation

carrier=ac*cos(2*%pi*fc*t);

subplot(4,1,2);
plot(t,carrier);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Carrier Signal');


// Hilbert Transform of Message Signal

h_msg=imag(hilbert(msg)); 

subplot(4,1,3);
plot(t,h_msg);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Message Signal');

// Hilbert Transform of Carrier Signal

h_carrier=imag(hilbert(carrier));

subplot(4,1,4);
plot(t,h_carrier);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Message Signal');



//SINGLE SIDE BAND MODULATION GENERATION
ssbmod_lsb=(msg.*carrier)+(h_msg.*h_carrier) //Lower Side Band

figure(2)
subplot(4,1,1);
plot(t,ssbmod_lsb);
xlabel('time');
ylabel('amplitude')
title('SSB Modulated Signal (LSB)');

ssbmod_usb=(msg.*carrier)-(h_msg.*h_carrier) //Upper Side Band
subplot(4,1,2);
plot(t,ssbmod_usb);
xlabel('time');
ylabel('amplitude')
title('SSB Modulated Signal (USB)');

//Frqeuncy Spectrum of SSB (LSB) Signal
d=(-p/2:1:p/2-1)*1/2;
subplot(4,1,3);
plot(d,abs(fftshift(fft(ssbmod_lsb))));// Normalized Frequency spectrum
xlabel('frequency');
ylabel('amplitude');
title('SSB Signal Spectrum (LSB)')

//Frqeuncy Spectrum of SSB (USB) Signal

subplot(4,1,4);
plot(d,abs(fftshift(fft(ssbmod_usb))));// Normalized Frequency spectrum
xlabel('frequency');
ylabel('amplitude');
title('SSB Signal Spectrum (USB)')


//Demodulation of SSB Signal
demod=ssbmod_lsb.*carrier;
k=abs(fft(demod));
filt = [ones(1,3*fm), zeros(1,p-3*fm) ];
out=k.*filt;
figure(3)
subplot(3,1,1);
plot(t,ifft(out));
xlabel('TIME');
ylabel('AMPLITUDE');
title('Demodulated Message')

// Sample Inputs for the Program
 
//Enter the message signal frequency =2

//Enter the carrier signal frequency (fc>>>fm) =20

//Enter the message signal amplitude =2

//Enter the carrier signal amplitude =3




